;; Die ersten drei Zeilen dieser Datei wurden von DrScheme eingefügt. Sie enthalten Metadaten
;; über die Sprachebene dieser Datei in einer Form, die DrScheme verarbeiten kann.
#reader(lib "DMdA-vanilla-reader.ss" "deinprogramm")((modname kapitel-8b) (read-case-sensitive #f) (teachpacks ()) (deinprogramm-settings #(#f write repeating-decimal #f #t none explicit #f ())))
; Kapitel 8

; filter

; aus einer Liste eine Liste der Elemente bilden,
; die eine bestimmte Eigenschaft haben
(: filter ((%a -> boolean) (list-of %a) -> (list-of %a)))
(check-expect (filter even? (list 1 2 3 4 5 6 7 8)) (list 2 4 6 8))

(define filter
  (lambda (p? lis)
    (cond
      ((empty? lis) empty)
      ((pair? lis)
       (if (p? (first lis))
           (make-pair (first lis)
                      (filter p? (rest lis)))
           (filter p? (rest lis)))))))

; Ein Gast ist besteht aus
; - einer Zeichenkette für den Namen
; - einem boolschen Wert, der angibt ob es sich um einen Mann oder ein Frau handelt
; - einem boolschen Wert, der angibt ob es sich um einen Vegetarier handelt
(: make-guest (string boolean boolean -> guest))
(: guest? (any -> boolean))
(: guest-name (guest -> string))
(: guest-male? (guest -> boolean))
(: guest-vegetarian? (guest -> boolean))

(define-record-procedures guest
  make-guest guest?
  (guest-name guest-male? guest-vegetarian?))

; Axls Party
(: party (list-of guest))
(define party
  (list
   (make-guest "Axl" #t #f)
   (make-guest "Stephanie" #f #t)
   (make-guest "Slash" #t #f) 
   (make-guest "Erin" #f #f)))

; aus einer Gästeliste eine Liste der Vegetarier bilden
(: vegetarian-guests ((list-of guest) -> (list-of guest)))
(check-expect (vegetarian-guests party) (list (make-guest "Stephanie" #f #t)))

(define vegetarian-guests
  (lambda (lis)
    (filter guest-vegetarian? lis)))

; aus einer Gästeliste eine Liste der Männer bilden
(: male-guests ((list-of guest) -> (list-of guest)))
(check-expect (male-guests party) (list (make-guest "Axl" #t #f)  (make-guest "Slash" #t #f)))

(define male-guests
  (lambda (lis)
    (filter guest-male? lis)))