;; Die ersten drei Zeilen dieser Datei wurden von DrScheme eingefügt. Sie enthalten Metadaten
;; über die Sprachebene dieser Datei in einer Form, die DrScheme verarbeiten kann.
#reader(lib "DMdA-beginner-reader.ss" "deinprogramm")((modname kapitel-4) (read-case-sensitive #f) (teachpacks ()) (deinprogramm-settings #(#f write repeating-decimal #f #t none explicit #f ())))
; Kapitel 4

(define double-choc (make-chocolate-cookie 24 14))

; Gewicht eines Schokokekses bestimmen
(: chocolate-cookie-weight (chocolate-cookie -> number))
(check-expect (chocolate-cookie-weight double-choc) 38)
(check-expect (chocolate-cookie-weight (make-chocolate-cookie 1 2)) 3)

(define chocolate-cookie-weight
  (lambda (c)
    (+ (chocolate-cookie-cookie c)
       (chocolate-cookie-chocolate c))))

; Eine kartesische Koordinate besteht aus
; - einer Zahl für die X-,
; - einer Zahl für die Y-Koordinate
(: make-cartesian (number number -> cartesian))
(: cartesian? (any -> boolean))
(: cartesian-x (cartesian -> number))
(: cartesian-y (cartesian -> number))

(define-record-procedures cartesian
  make-cartesian cartesian?
  (cartesian-x cartesian-y))

; Quadrat einer Zahl bestimmen
(: square (number -> number))
(check-expect (square 0) 0)
(check-expect (square 1) 1)
(check-expect (square 3) 9)

(define square
  (lambda (x)
    (* x x)))

; Abstand vom Ursprung berechnen
(: distance-to-origin (cartesian -> number))
(check-within (distance-to-origin (make-cartesian 2 2)) (sqrt 8) 0.01)
(check-within (distance-to-origin (make-cartesian (sqrt 8) (sqrt 8))) 4 0.01)

(define distance-to-origin
  (lambda (c)
    (sqrt
     (+ (square (cartesian-x c))
        (square (cartesian-y c))))))

; Schokoladenkeks doppeldeckern
(: double-chocolate-cookie (chocolate-cookie -> chocolate-cookie))
(check-expect (double-chocolate-cookie (make-chocolate-cookie 2 3)) (make-chocolate-cookie 4 6))
(check-expect (double-chocolate-cookie (make-chocolate-cookie 3 6)) (make-chocolate-cookie 6 12))

(define double-chocolate-cookie
  (lambda (c)
    (make-chocolate-cookie
     (* 2 (chocolate-cookie-chocolate c))
     (* 2 (chocolate-cookie-cookie c)))))

; Ein Stapel ist entweder die Zeichenkette "left" für den
; linken Stapel oder "right" für den rechten Stapel
(define stack (contract (one-of "left" "right")))

; Ein Nim-Spielstand besteht aus
; - einer Anzahl von Münzen auf dem linken Stapel
; - einer Anzahl von Münzen auf dem rechten Stapel 
(: make-nim-score (natural natural -> nim-score))
(: nim-score? (any -> boolean))
(: nim-score-left (nim-score -> number))
(: nim-score-right (nim-score -> number))

(define-record-procedures nim-score
  make-nim-score nim-score?
  (nim-score-left nim-score-right))

; Ein Nim-Spielzug besteht aus
; - einem Stapel
; - einer Anzahl von Münzen
(: make-nim-move (stack natural -> nim-move))
(: nim-move? (any -> boolean))
(: nim-move-stack (nim-move -> stack))
(: nim-move-count (nim-move -> natural))

(define-record-procedures nim-move
  make-nim-move nim-move?
  (nim-move-stack nim-move-count))

; Spielstand nach einem Spielzug berechnen
(: apply-nim-move (nim-score nim-move -> nim-score))
(check-expect (apply-nim-move (make-nim-score 5 6) (make-nim-move "left" 3)) (make-nim-score 2 6))
(check-expect (apply-nim-move (make-nim-score 5 6) (make-nim-move "right" 4)) (make-nim-score 5 2))

(define apply-nim-move
  (lambda (s m)
    (cond
      ((string=? (nim-move-stack m) "left")
       (make-nim-score 
        (- (nim-score-left s) (nim-move-count m))
        (nim-score-right s)))
      ((string=? (nim-move-stack m) "right")
       (make-nim-score 
        (nim-score-left s)
        (- (nim-score-right s) (nim-move-count m)))))))

; Alternative Version:

; (define apply-nim-move
;   (lambda (s m)
;     (make-nim-score 
;       (cond
;         ((string=? (nim-move-stack m) "left")
;          (- (nim-score-left s) (nim-move-count m)))
;         ((string=? (nim-move-stack m) "right")
;          (nim-score-left s)))
;       (cond
;         ((string=? (nim-move-stack m) "left")
;          (nim-score-right s))
;         ((string=? (nim-move-stack m) "right")
;          (- (nim-score-right s) (nim-move-count m)))))))



; Ein Marmelade-Creme-Keks besteht aus
; - einer Zahl für den Creme-,
; - einer Zahl für den Marmeladen-,
; - einer Zahl für den Keks-Anteil
(: make-jelly-cream-cookie (natural natural natural -> jelly-cream-cookie))
(: jelly-cream-cookie? (any -> boolean))
(: jelly-cream-cookie-cream (jelly-cream-cookie -> natural))
(: jelly-cream-cookie-jelly (jelly-cream-cookie -> natural))
(: jelly-cream-cookie-cookie (jelly-cream-cookie -> natural))

(define-record-procedures jelly-cream-cookie
  make-jelly-cream-cookie jelly-cream-cookie?
  (jelly-cream-cookie-cream
   jelly-cream-cookie-jelly
   jelly-cream-cookie-cookie))

; Marmelade-Creme-Keks doppeldeckern
(: double-jelly-cream-cookie (jelly-cream-cookie -> jelly-cream-cookie))
(check-expect (double-jelly-cream-cookie (make-jelly-cream-cookie 1 2 3)) (make-jelly-cream-cookie 2 4 6))

(define double-jelly-cream-cookie
  (lambda (c)
    (make-jelly-cream-cookie
     (* 2 (jelly-cream-cookie-cream c))
     (* 2 (jelly-cream-cookie-jelly c))
     (* 2 (jelly-cream-cookie-cookie c)))))


; Ein Keks ist eins der folgenden:
; - ein Schokokeks oder
; - ein Marmelade-Creme-Keks
; Name: cookie
(define cookie (contract (mixed chocolate-cookie jelly-cream-cookie)))
; Keks doppeldeckern
(: double-cookie (cookie -> cookie))
(check-expect (double-cookie (make-jelly-cream-cookie 1 2 3)) (make-jelly-cream-cookie 2 4 6))
(check-expect (double-cookie (make-chocolate-cookie 2 3)) (make-chocolate-cookie 4 6))

(define double-cookie
  (lambda (c)
    (cond
      ((chocolate-cookie? c)
       (double-chocolate-cookie c))
      ((jelly-cream-cookie? c)
       (double-jelly-cream-cookie c)))))
