;; Die ersten drei Zeilen dieser Datei wurden von DrScheme eingefügt. Sie enthalten Metadaten
;; über die Sprachebene dieser Datei in einer Form, die DrScheme verarbeiten kann.
#reader(lib "DMdA-beginner-reader.ss" "deinprogramm")((modname kapitel-3) (read-case-sensitive #f) (teachpacks ()) (deinprogramm-settings #(#f write repeating-decimal #f #t none explicit #f ())))
; Kapitel 3

; aus einer Temperatur den Aggregatzustand von Wasser bestimmen
(: state-of-aggregation (number -> (one-of "frozen" "liquid" "gaseous")))
(check-expect (state-of-aggregation -10) "frozen")
(check-expect (state-of-aggregation 0) "frozen")
(check-expect (state-of-aggregation 10) "liquid")
(check-expect (state-of-aggregation 100) "gaseous")

(define state-of-aggregation
  (lambda (T)
    (cond
      ((<= T 0) "frozen")
      ((< T 100) "liquid")
      (else "gaseous"))))


; Absolutbetrag einer Zahl berechnen
(: absolute (number -> number))
; (define absolute
;   (lambda (x)
;     (cond
;      ((>= x 0) x)
;      (else (- x)))))
(check-expect (absolute 0) 0)
(check-expect (absolute -5) 5)
(check-expect (absolute 7) 7)

(define absolute
  (lambda (x)
    (if (>= x 0)
        x
        (- x))))

; feststellen, ob Temperatur mild ist
(: temperature-mild? (number -> boolean))
; (define temperature-mild?
;   (lambda (T)
;     (if (>= T 4)
;         (if (<= T 12)
;             #t
;             #f)
;         #f)))

; (define temperature-mild?
;   (lambda (T)
;     (if (and (>= T 4) (<= T 12))
;         #t
;         #f)))
(check-expect (temperature-mild? 10) #t)
(check-expect (temperature-mild? 14) #f)
(check-expect (temperature-mild? -1) #f)
(check-expect (temperature-mild? 4) #t)

(define temperature-mild?
  (lambda (T)
    (and (>= T 4) (<= T 12))))

; feststellen, ob Temperatur unangenehm ist
(: temperature-uncomfortable? (number -> boolean))
; (define temperature-uncomfortable?
;   (lambda (T)
;     (or (< T 14) (> T 34))))
(check-expect (temperature-uncomfortable? 23) #f)
(check-expect (temperature-uncomfortable? 23.5) #t)

(define temperature-uncomfortable?
  (lambda (T)
    (not (= T 23))))
